% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakAccessors.R
\docType{methods}
\name{featuresPerGene,CopyNumberBreakPointGenes-method}
\alias{featuresPerGene}
\alias{featuresPerGene,CopyNumberBreakPointGenes-method}
\title{Access Object featuresPerGene. This method returns a vector with gene-related features for a particular gene.}
\usage{
\S4method{featuresPerGene}{CopyNumberBreakPointGenes}(object, geneName = NULL)
}
\arguments{
\item{object}{An object of class \code{CopyNumberBreakPoints}}

\item{geneName}{Exact Gene name as in the annotation}
}
\value{
a vector with gene-related features
}
\description{
Access Object featuresPerGene. This method returns a vector with gene-related features for a particular gene.
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )

featuresPerGene( bp, geneName="PCMTD2" )
}

