% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeneBreakMethods.R
\docType{methods}
\name{bpStats,CopyNumberBreakPoints-method}
\alias{bpStats}
\alias{bpStats,CopyNumberBreakPoints-method}
\title{bpStats}
\usage{
\S4method{bpStats}{CopyNumberBreakPoints}(object, level = "gene",
  method = "BH", fdr.threshold = 1)
}
\arguments{
\item{object}{An object of class \linkS4class{CopyNumberBreakPointGenes}}

\item{level}{The level at which to operate, this can be either "gene" (correcting for gene length) or "feature" (per probe/bin)}

\item{method}{The FDR correction method to apply. This can be "BH" (applies Benjamini-Hochberg-type FDR correction) or "Gilbert" (for dedicated Benjamini-Hochberg-type FDR correction)}

\item{fdr.threshold}{The threshold for FDR correction'}
}
\value{
Returns an object of class \linkS4class{CopyNumberBreakPointGenes} with cohort based statistics added.
}
\description{
Applies cohort-based statistics to identify genes and/or chromosomal locations that are recurrently affected by breakpoints.
}
\details{
The statistical method on gene-level corrects for covariates that may influence the probability to be a breakpoint gene including number of breakpoints in a profile, number of gene-associated features and gene length by gene-associated feature coverage. The statistical analysis includes multiple testing where standard Benjamini-Hochberg-type FDR correction will be performed by default. This less computational intensive method assumes a similar null-distribution for all candidate breakpoint events and satisfies for analysis on breakpoint location-level. For statistics on gene-level however, we recommend to apply the more comprehensive and powerful dedicated Benjamini-Hochberg-type FDR correction that accounts for discreteness in null-distribution (Gilbert, 2005) following correction for covariates that may influence the probability to be a breakpoint gene including number of breakpoints in a profile, number of gene-associated features and gene length by gene-associated feature coverage.
}
\examples{
data( copynumber.data.chr20 )
data( ens.gene.ann.hg18 )
bp <- getBreakpoints( copynumber.data.chr20 )
bp <- bpFilter( bp )
bp <- addGeneAnnotation( bp, ens.gene.ann.hg18 )
bp <- bpGenes( bp )
bp <- bpStats( bp )

## options to inspect the data
bp
accessOptions( bp )
}
\references{
Gilbert,P.B. (2005) A modified false discovery rate multiple-comparisons procedure for discrete data, applied to human immunodeficiency virus genetics. Journal of the Royal Statistical Society Series C-Applied Statistics, 54, 143-158.
}

