% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{seedFinding}
\alias{seedFinding}
\title{Find clustering seeds}
\usage{
seedFinding(distances, simThreshold, memThreshold)
}
\arguments{
\item{distances}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of (distance) scores}

\item{simThreshold}{numerical, A threshold to determine which genesets are
considered close (i.e. have a distance <= simThreshold)
in the \code{distances} matrix.}

\item{memThreshold}{numerical, A threshold used to ensure that enough members
of a potential seed set are close/similar to each other.
Only if this condition is met, the set is considered a
seed.}
}
\value{
A \code{list} of seeds which can be used for clustering
}
\description{
Determine initial seeds for the clustering from the distance score matrix.
}
\examples{
## Mock example showing how the data should look like

m <- Matrix::Matrix(stats::runif(100, min = 0, max = 1), 10, 10)
seeds <- seedFinding(distances = m, simThreshold = 0.3, memThreshold = 0.5)

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())

seeds <- seedFinding(scores_macrophage_topGO_example_small,
                     simThreshold = 0.3,
                     memThreshold = 0.5)
}
\references{
See https://david.ncifcrf.gov/helps/functional_classification.html#clustering
for details on the original implementation
}
