% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sorensen_dice_Scoring.R
\name{getSorensenDiceMatrix}
\alias{getSorensenDiceMatrix}
\title{Get Matrix of Sorensen-Dice distances}
\usage{
getSorensenDiceMatrix(genesets)
}
\arguments{
\item{genesets}{a \code{list}, A \code{list} of genesets where each genesets is
represented by \code{list} of genes.}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} with Sorensen-Dice distance rounded to 2 decimal
places.
}
\description{
Calculate the Sorensen-Dice distance of all combinations of genesets in a
given data set of genesets.
}
\examples{
## Mock example showing how the data should look like
genesets <- list(list("PDHB", "VARS2"), list("IARS2", "PDHA1"))
m <- getSorensenDiceMatrix(genesets)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
sd_matrix <- getSorensenDiceMatrix(genes)
}
