% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meetmin_Scoring.R
\name{getMeetMinMatrix}
\alias{getMeetMinMatrix}
\title{Get Matrix of Meet-Min distances}
\usage{
getMeetMinMatrix(genesets)
}
\arguments{
\item{genesets}{a \code{list}, A \code{list} of genesets where each genesets is
represented by \code{list} of genes.}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} with Meet-Min distance rounded to 2 decimal
places.
}
\description{
Calculate the Meet-Min distance of all combinations of genesets in a given
data set of genesets.
}
\examples{
## Mock example showing how the data should look like
genesets <- list(list("PDHB", "VARS2"), list("IARS2", "PDHA1"))
m <- getMeetMinMatrix(genesets)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
mm <- getMeetMinMatrix(genes)
}
