% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pMM_Scoring.R
\name{getInteractionScore}
\alias{getInteractionScore}
\title{Calculate interaction score for two genesets}
\usage{
getInteractionScore(a, b, ppi, maxInteract)
}
\arguments{
\item{a, b}{character vector, set of gene identifiers.}

\item{ppi}{a \code{data.frame}, Protein-protein interaction (PPI) network data
frame. The object is expected to have three columns, \code{Gene1} and
\code{Gene2} which specify the gene names of the interacting proteins
in no particular order (symmetric interaction) and a column
\code{combined_score} which is a numerical value of the strength of
the interaction.}

\item{maxInteract}{numeric, Maximum interaction value in the PPI.}
}
\value{
Interaction score between the two gene sets.
}
\description{
The function calculates an interaction score between two sets of genes based
on a protein-protein interaction network.
}
\examples{
## Mock example showing how the data should look like
a <- c("PDHB", "VARS2", "IARS2")
b <- c("IARS2", "PDHA1")

ppi <- data.frame(
  Gene1 = c("PDHB", "VARS2", "IARS2"),
  Gene2 = c("IARS2", "PDHA1", "CD3"),
  combined_score = c(0.5, 0.2, 0.1)
)
maxInteract <- max(ppi$combined_score)

interaction <- getInteractionScore(a, b, ppi, maxInteract)

## Example using the data available in the package
data(macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
genes <- GeDi::prepareGenesetData(macrophage_topGO_example_small)
data(ppi_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())
maxInteract <- max(ppi_macrophage_topGO_example_small$combined_score)

interaction <- getInteractionScore(genes[1], genes[2], ppi, maxInteract)
}
\references{
See https://doi.org/10.1186/s12864-019-5738-6 for details on the original
implementation.
}
