% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getGenes}
\alias{getGenes}
\title{Split string of genes}
\usage{
getGenes(genesets, gene_name = NULL)
}
\arguments{
\item{genesets}{a \code{data.frame}, A \code{data.frame} with at least two columns.
One should be called \code{Geneset}, containing the
names/identifiers of the genesets in the data. The second
column should be called \code{Genes} and contains one string of
the genes contained in each geneset.}

\item{gene_name}{a character, Alternative name for the column containing the
genes in \code{genesets}. If not given, the column is expected to
be called \code{Genes}.}
}
\value{
A \code{list} containing for each geneset in the \code{Geneset} column a
\code{list} of the included genes.
}
\description{
Split a long string of space separated genes into a \code{list} of individual
genes.
}
