% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_Graph.R
\name{getAdjacencyMatrix}
\alias{getAdjacencyMatrix}
\title{Construct an adjacency matrix}
\usage{
getAdjacencyMatrix(distanceMatrix, cutOff, weighted = FALSE)
}
\arguments{
\item{distanceMatrix}{A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} containing (distance) scores
between 0 and 1.}

\item{cutOff}{Numeric value, indicating for which pair of entries in the
\code{distanceMatrix} a 1 should be inserted in the adjacency
matrix. A 1 is inserted when for each entry in the matrix
that is smaller or equal to the \code{cutOff} value.}

\item{weighted}{logical value, indicating whether or not the resulting
adjacency matrix should be weighted. If TRUE, the matrix will
be weighted by the distance scores in \code{distanceMatrix}.
Defaults to FALSE.}
}
\value{
A \code{\link[Matrix:Matrix]{Matrix::Matrix()}} of adjacency status
}
\description{
Construct an adjacency matrix from the (distance) scores and a given
threshold.
}
\examples{
m <- Matrix::Matrix(stats::runif(1000, 0, 1), 100, 100)
geneset_names <- as.character(stats::runif(100, min = 0, max = 1))
rownames(m) <- colnames(m) <- geneset_names
threshold <- 0.3
adj <- getAdjacencyMatrix(m, threshold)
}
