% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{fuzzyClustering}
\alias{fuzzyClustering}
\title{Find cluster from initial seeds}
\usage{
fuzzyClustering(seeds, threshold)
}
\arguments{
\item{seeds}{A \code{list} of seeds, e.g. determined by \code{GeDi::seedFinding()}
function}

\item{threshold}{numerical, A threshold for merging seeds}
}
\value{
A \code{list} of clusters
}
\description{
Merge the initially determined seeds to clusters.
}
\examples{
## Mock example showing how the data should look like

seeds <- list(c(1:5), c(6:10))
cluster <- fuzzyClustering(seeds, 0.5)

## Example using the data available in the package
data(scores_macrophage_topGO_example_small,
     package = "GeDi",
     envir = environment())

seeds <- seedFinding(scores_macrophage_topGO_example_small,
                     simThreshold = 0.3,
                     memThreshold = 0.5)
cluster <- fuzzyClustering(seeds, threshold = 0.5)
}
\references{
See https://david.ncifcrf.gov/helps/functional_classification.html#clustering
for details on the original implementation
}
