% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_wordcloud.R
\name{enrichmentWordcloud}
\alias{enrichmentWordcloud}
\title{Visualize the results of an enrichment analysis as word cloud}
\usage{
enrichmentWordcloud(
  genesets_df,
  remove_generic_terms = FALSE,
  terms_to_remove = c()
)
}
\arguments{
\item{genesets_df}{A \code{data.frame} object of an enrichment analysis results.
This object should follow the input requirements of
\code{GeDi()}, check out the vignette for further details.
Besides the specified required columns, the object should
ideally include a column with a short geneset description
which is used for the word cloud. If no such column is
available, the row names of the \code{data.frame} are used for
the word cloud.}

\item{remove_generic_terms}{Logical, If generic terms like "via", "protein",
"factor", "side", "type", "specific",
"regulation" and "process" should be removed from
the wordcloud. Default to FALSE.}

\item{terms_to_remove}{Character vector, A vector of additional terms that
should be removed from the wordcloud.}
}
\value{
A \code{\link[wordcloud2:wordcloud2]{wordcloud2::wordcloud2()}} plot object
}
\description{
Visualize the results of an enrichment analysis as a word cloud. The word
cloud highlights the most frequent terms associated with the description of
the genesets in the enrichment analysis.
}
\examples{
## Mock example showing how the data should look like

## If no "Term" or "Description" column is available,
## the rownames of the data frame will be used.
geneset_df <- data.frame(
              Genesets = c("GO:0002503", "GO:0045087", "GO:0019886"),
              Genes = c("B2M, HLA-DMA, HLA-DMB",
                        "ACOD1, ADAM8, AIM2",
                        "B2M, CD74, CTSS")
)
rownames(geneset_df) <- geneset_df$Genesets

wordcloud <- enrichmentWordcloud(geneset_df)

## With available "Term" column.
geneset_df <- data.frame(
              Genesets = c("GO:0002503", "GO:0045087", "GO:0019886"),
              Genes = c("B2M, HLA-DMA, HLA-DMB",
                        "ACOD1, ADAM8, AIM2",
                        "B2M, CD74, CTSS"),
              Term = c(
              "peptide antigen assembly with MHC class II protein complex",
              "innate immune response",
              "antigen processing and presentation of exogenous
               peptide antigen via MHC class II")
)

wordcloud <- enrichmentWordcloud(geneset_df)


## Example using the data available in the package

data(macrophage_topGO_example,
     package = "GeDi",
     envir = environment())
wordcloud <- enrichmentWordcloud(macrophage_topGO_example)
}
