% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{.cluster_markov}
\alias{.cluster_markov}
\title{Markov Clustering (MCL) for community detection}
\usage{
.cluster_markov(
  g,
  add_self_loops = TRUE,
  loop_value = 1,
  mcl_expansion = 2,
  mcl_inflation = 2,
  allow_singletons = TRUE,
  max_iter = 100,
  return_node_names = TRUE,
  return_esm = FALSE
)
}
\arguments{
\item{g}{The input graph object}

\item{add_self_loops}{Logical, whether to add self-loops to the matrix by
setting the diagonal to \code{loop_value}}

\item{loop_value}{Numeric, the value to use for self-loops}

\item{mcl_expansion}{Numeric, cluster expansion factor for the Markov clustering
iteration - defaults to 2}

\item{mcl_inflation}{Numeric, cluster inflation factor for the Markov clustering
iteration - defaults to 2}

\item{allow_singletons}{Logical; if \code{TRUE}, single isolated vertices are allowed
to form their own cluster. If set to \code{FALSE}, all clusters of size = 1 are
grouped in one cluster (to be interpreted as background noise).}

\item{max_iter}{Numeric value for the maximum number of iterations for the
Markov clustering}

\item{return_node_names}{Logical, if the graph is named and set to \code{TRUE}, returns
the node names.}

\item{return_esm}{Logical, controlling whether the equilibrium state matrix should be returned}
}
\value{
This function returns a \code{communities} object, containing the numbers of
the assigned membership (in the slot \code{membership}). Please see the
\code{\link[igraph:communities]{igraph::communities()}} manual page for additional details
}
\description{
This function implements the Markov Clustering (MCL) algorithm for finding community
structure, in an analogous way to other existing algorithms in \code{igraph}.
}
\details{
This implementation has been driven by the nice explanations provided in
\itemize{
\item https://sites.cs.ucsb.edu/~xyan/classes/CS595D-2009winter/MCL_Presentation2.pdf
\item https://medium.com/analytics-vidhya/demystifying-markov-clustering-aeb6cdabbfc7
\item https://github.com/GuyAllard/markov_clustering (python implementation)
}

More info on the MCL: https://micans.org/mcl/index.html, and
https://micans.org/mcl/sec_description1.html
}
\examples{
library("igraph")
g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1, 6, 1, 11, 6, 11))
.cluster_markov(g)
V(g)$color <- .cluster_markov(g)$membership
plot(g)
}
\references{
van Dongen, S.M., Graph clustering by flow simulation (2000) PhD thesis,
Utrecht University Repository - https://dspace.library.uu.nl/handle/1874/848

Enright AJ, van Dongen SM, Ouzounis CA, An efficient algorithm for
large-scale detection of protein families (2002) Nucleic Acids Research, Volume 30,
Issue 7, 1 April 2002, Pages 1575–1584, https://doi.org/10.1093/nar/30.7.1575
}
