% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/offTargetAnalysisWithBulge.R
\name{offTargetAnalysisWithBulge}
\alias{offTargetAnalysisWithBulge}
\title{offTarget Analysis With Bulges Allowed
Finding offtargets around peaks from GUIDE-seq or around any given
genomic regions with bulges allowed in gRNA or the DNA sequence of
offTargets when aligning gRNA and DNA sequences.}
\usage{
offTargetAnalysisWithBulge(
  gRNA,
  gRNA.name,
  peaks,
  BSgenomeName,
  mat,
  peaks.withHeader = FALSE,
  peaks.format = "bed",
  gapOpening = 1L,
  gapExtension = 3L,
  max.DNA.bulge = 2L,
  max.mismatch = 10L,
  allowed.mismatch.PAM = 2L,
  upstream = 20L,
  downstream = 20L,
  PAM.size = 3L,
  gRNA.size = 20L,
  PAM = "NGG",
  PAM.pattern = "NNN$",
  PAM.location = "3prime",
  mismatch.activity.file = system.file("extdata",
    "NatureBiot2016SuppTable19DoenchRoot.xlsx", package = "GUIDEseq")
)
}
\arguments{
\item{gRNA}{a character string containing the gRNA sequence
without PAM}

\item{gRNA.name}{name of the gRNA}

\item{peaks}{peak input file path or a GenomicRanges object that contains
genomic regions to be searched for potential offtargets}

\item{BSgenomeName}{BSgenome object. Please refer to available.genomes in
BSgenome package. For example, BSgenome.Hsapiens.UCSC.hg19 for hg19,
BSgenome.Mmusculus.UCSC.mm10 for mm10, BSgenome.Celegans.UCSC.ce6 for ce6,
BSgenome.Rnorvegicus.UCSC.rn5 for rn5, BSgenome.Drerio.UCSC.danRer7 for Zv9,
and BSgenome.Dmelanogaster.UCSC.dm3 for dm3}

\item{mat}{nucleotideSubstitutionMatrix, which can be created using
nucleotideSubstitutionMatrix.}

\item{peaks.withHeader}{Indicate whether the peak input file contains
header, default FALSE}

\item{peaks.format}{format of the peak file, default to bed file format.
Currently, only bed format is supported}

\item{gapOpening}{Gap opening penalty, default to 1L}

\item{gapExtension}{Gap extension penalty, default to 3L}

\item{max.DNA.bulge}{Total number of bulges allowed, including bulges
in DNA and gRNA, default to 2L}

\item{max.mismatch}{Maximum mismatch allowed in off target search, default
10L}

\item{allowed.mismatch.PAM}{Number of degenerative bases in the PAM.pattern
sequence, default to 2L}

\item{upstream}{upstream offset from the peak start to search for off
targets, default 20}

\item{downstream}{downstream offset from the peak end to search for off
targets, default 20}

\item{PAM.size}{PAM length, default 3}

\item{gRNA.size}{The size of the gRNA, default 20}

\item{PAM}{PAM sequence after the gRNA, default NGG}

\item{PAM.pattern}{Regular expression of protospacer-adjacent motif (PAM),
default to any NNN$. Currently, only support NNN$}

\item{PAM.location}{PAM location relative to gRNA. For example, default to
3prime for spCas9 PAM.  Please set to 5prime for cpf1 PAM since it's PAM is
located on the 5 prime end}

\item{mismatch.activity.file}{Applicable only when scoring.method is set to
CFDscore A comma separated (csv) file containing the cleavage rates for all
possible types of single nucleotide mismatch at each position of the gRNA.
By default, using the supplemental Table 19 from Doench et al., Nature
Biotechnology 2016}
}
\description{
offTarget Analysis With Bulges Allowed
Finding offtargets around peaks from GUIDE-seq or around any given
genomic regions with bulges allowed in gRNA or the DNA sequence of
offTargets when aligning gRNA and DNA sequences.
}
\examples{

if (interactive()) {
  library(GUIDEseq)
  peaks <- system.file("extdata","1450-chr14-chr2-bulge-test.bed", package = "GUIDEseq")
  mismatch.activity.file <-system.file("extdata", "NatureBiot2016SuppTable19DoenchRoot.xlsx",
    package = "GUIDEseq")

  gRNA <- "TGCTTGGTCGGCACTGATAG"
  gRNA.name <- "Test1450"
  library(BSgenome.Hsapiens.UCSC.hg38)

  temp <- offTargetAnalysisWithBulge(gRNA = gRNA, gRNA.name = gRNA.name,
     peaks = peaks, BSgenomeName = Hsapiens,
     mismatch.activity.file = mismatch.activity.file)
}
}
\author{
Lihua Julie Zhu
}
