% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-functions.R
\name{plot_pareto}
\alias{plot_pareto}
\title{Plot pareto front from an galgo.Obj}
\usage{
plot_pareto(output)
}
\arguments{
\item{output}{An object of class \code{galgo.Obj}}
}
\value{
This function returns a scatterplot showing the solutions found by 
Galgo accross all generations in the solution space, where the Silhouette 
Fitness is in the x-axis and the survival fitness in the y-axis.
A line is drawn over all non-dominated solutions showing the estimated 
Pareto front
}
\description{
Plot pareto front from an galgo.Obj
}
\examples{
# load example dataset
library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)

expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)

# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo
output <- GSgalgoR::galgo(generations = 5, population = 15, 
prob_matrix = expression, OS = OS)
plot_pareto(output)
}
