% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results-functions.R
\name{non_dominated_summary}
\alias{non_dominated_summary}
\title{Summary of the non dominated solutions}
\usage{
non_dominated_summary (output, prob_matrix, OS,
distancetype = "pearson")
}
\arguments{
\item{output}{An object of class \code{galgo.Obj}}

\item{prob_matrix}{a \code{matrix} or \code{data.frame}. Must be an
expression matrix with features in rows and samples in columns}

\item{OS}{a \code{survival} object (see \code{\link[survival]{Surv}}
function from the \code{\link{survival}} package)}

\item{distancetype}{a \code{character} that can be either \code{'pearson'},
\code{'uncentered'}, \code{'spearman'} or \code{'euclidean'}}
}
\value{
Returns a \code{data.frame} with 5 columns and a number of rows
equals to the non-dominated solutions found by GalgoR.
The first column has the name of the non-dominated solutions, the second
the number of partitions found for each solution \code{(k)}, the third,
the number of genes, the fourth the mean silhouette coefficient of the
solution and the last columns has the estimated C.Index for each one.
}
\description{
The function uses a \code{'galgo.Obj'} as input an the training dataset to
evaluate the non-dominated solutions found by GalgoR
}
\examples{
# load example dataset
library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)

expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)

# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo
output <- GSgalgoR::galgo(generations = 5, population = 15,
prob_matrix = expression, OS = OS)
non_dominated_summary(
    output = output,
    OS = OS,
    prob_matrix = expression,
    distancetype = "pearson"
)
}
