% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback-functions.R
\name{callback_default}
\alias{callback_default}
\title{A default call_back function that does nothing.}
\usage{
callback_default (userdir = "",generation, pop_pool, 
pareto, prob_matrix, current_time)
}
\arguments{
\item{userdir}{the default directory used by \code{galgo()} to store files}

\item{generation}{a number indicating the number of iterations of the 
galgo algorithm}

\item{pop_pool}{a \code{data.frame} with the solution vectors, number 
of clusters and their ranking.}

\item{pareto}{the solutions found by Galgo across all generations in 
the solution space}

\item{prob_matrix}{a \code{matrix} or \code{data.frame}. Must be an 
expression matrix with features in rows and samples in columns}

\item{current_time}{an \code{POSIXct} object}
}
\value{
Nothing
}
\description{
A default call_back function that does nothing.
}
\examples{
# load example dataset

library(breastCancerTRANSBIG)
data(transbig)
Train <- transbig
rm(transbig)
expression <- Biobase::exprs(Train)
clinical <- Biobase::pData(Train)
OS <- survival::Surv(time = clinical$t.rfs, event = clinical$e.rfs)
# We will use a reduced dataset for the example
expression <- expression[sample(1:nrow(expression), 100), ]

# Now we scale the expression matrix
expression <- t(scale(t(expression)))

# Run galgo with default_callback assigned to all the hook-points

GSgalgoR::galgo(generations = 5,
population = 15,
prob_matrix = expression,
OS = OS,
start_galgo_callback = callback_default,# When Galgo is about to start.
end_galgo_callback = callback_default,  # When Galgo is about to finish.
start_gen_callback = callback_default,  # At the beginning of each iteration.
end_gen_callback = callback_default,    # At the end of each iteration.
)


}
