% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_filter.R
\name{gm_filter}
\alias{gm_filter}
\title{gm_filter: GSEAmining GSEA output filter}
\usage{
gm_filter(df, p.adj = 0.05, neg_NES = 1, pos_NES = 1)
}
\arguments{
\item{df}{Data frame that contains at least three columns: an ID column for
the gene set names, a NES column with the normalized enrichment score and a
core_enrichment column containing the genes in the leading edge of each
gene set separated by '/'.}

\item{p.adj}{An integer to set the limit of the adjusted p-value (or false
discovery rate, FDR). Default value is 0.05}

\item{neg_NES}{A positive integer to set the limit of negative NES. Default
is 1.}

\item{pos_NES}{A positive integer to set the limit of positive NES. Default
is 1.}
}
\value{
A data frame.
}
\description{
Filters a data frame containing the results of GSEA analysis.
}
\examples{
data(genesets_sel)
gs.filt <- gm_filter(genesets_sel, p.adj = 0.05, neg_NES = 2.6, pos_NES = 2)

}
