% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_enrichterms.R
\name{gm_enrichterms}
\alias{gm_enrichterms}
\title{gm_enrichterms: GSEAmining enriched terms}
\usage{
gm_enrichterms(df, hc, clust = TRUE, col_pos = "red", col_neg = "blue")
}
\arguments{
\item{df}{Data frame that contains at least three columns: an ID column for
the gene set names, a NES column with the normalized enrichment score and a
core_enrichment column containing the genes in the leading edge of each
gene set separated by '/'.}

\item{hc}{The output of gm_clust, which is an hclust class object.}

\item{clust}{A logical value indicating if wordclouds should be separated by
clusters or not. Default value is TRUE.}

\item{col_pos}{Color to represent positively enriched gene sets. Default
is red.}

\item{col_neg}{Color to represent negatively enriched gene sets. Default
is blue.}
}
\value{
Returns a ggplot object.
}
\description{
Takes the output of gm_clust, which is an hclust class object,
and plots gene set enriched terms as wordclouds. Two options are available,
either separate enrichments by clusters or plot them together in a single
plot.
}
\examples{
data(genesets_sel)
gs.cl <- gm_clust(genesets_sel)
gm_enrichterms(genesets_sel, gs.cl)

}
