% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_dendplot.R
\name{gm_dendplot}
\alias{gm_dendplot}
\title{gm_dendplot: GSEAmining dendrogram plotter}
\usage{
gm_dendplot(
  df,
  hc,
  col_pos = "red",
  col_neg = "blue",
  dend_len = 30,
  rect = TRUE,
  rect_len = 2
)
}
\arguments{
\item{df}{Data frame that contains at least three columns: an ID column for
the gene set names, a NES column with the normalized enrichment score and a
core_enrichment column containing the genes in the leading edge of each
gene set separated by '/'.}

\item{hc}{The output of gm_clust, which is an hclust class object.}

\item{col_pos}{Color to represent the positively enriched gene sets. Default
is red.}

\item{col_neg}{Color to represent the negatively enriched gene sets. Default
is blue.}

\item{dend_len}{An integer that defines the length of the dendrogram. Default
value is 30. The closest to zero the longest the dendrogram.}

\item{rect}{A logical value indicating if rectangles should be drawn around
the clusters to help differentiating them. By default it is set to TRUE.}

\item{rect_len}{An integer to specify the length of the rectangle around the
cluster and the gene set label. Default is 2. The closest to zero the
smallest the rectangle.}
}
\value{
Invisibly returns a list with all the elements necessary to plot
a dendrogram.
}
\description{
Takes the output of gm_clust, which is an hclust class object,
and plots the dendrogram using the dendextend package.
}
\examples{
data(genesets_sel)
gs.cl <- gm_clust(genesets_sel)
gm_dendplot(genesets_sel, gs.cl)

}
