% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_group_cores.R
\name{clust_group_cores}
\alias{clust_group_cores}
\title{clust_group_cores}
\usage{
clust_group_cores(cg, top = 3)
}
\arguments{
\item{cg}{A data frame output from the GSEAmining clusts_groups function.}

\item{top}{An integer to choose the top most enriched genes to plot per
cluster. The default parameter are the top 3.}
}
\value{
A tibble with four variables (Cluster, Enrichment, lead_token, n).
}
\description{
Takes the output of clust_groups, a data frame , and process
it to obtain the enrichment of genes in the core enrichment (or leading
edge analysis) within each cluster. The output is used in the functions
gm_enrichcores and gm_enrichreport.
}
\examples{
data(genesets_sel)
gs.cl <- gm_clust(genesets_sel)
clust.groups <- clust_groups(genesets_sel, gs.cl)
clust.lead <- clust_group_cores(clust.groups, top = 3)

}
