% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark.R
\name{evalRandomGS}
\alias{evalRandomGS}
\title{Evaluation of enrichment methods on random gene sets}
\usage{
evalRandomGS(
  method,
  se,
  nr.gs = 100,
  set.size = 5,
  alpha = 0.05,
  padj = "none",
  perc = TRUE,
  reps = 100,
  rep.block.size = -1,
  summarize = TRUE,
  save2file = FALSE,
  out.dir = NULL,
  ...
)
}
\arguments{
\item{method}{Enrichment analysis method.  A character scalar chosen 
from \code{\link{sbeaMethods}} and \code{\link{nbeaMethods}}, or a user-defined
function implementing a method for enrichment analysis.}

\item{se}{An expression dataset of class \code{\linkS4class{SummarizedExperiment}}.}

\item{nr.gs}{Integer. Number of random gene sets. Defaults to 100.}

\item{set.size}{Integer. Gene set size, i.e. number of genes in each random gene set.}

\item{alpha}{Numeric. Statistical significance level. Defaults to 0.05.}

\item{padj}{Character. Method for adjusting p-values to multiple testing.
For available methods see the man page of the stats function
\code{\link{p.adjust}}. Defaults to \code{"none"}.}

\item{perc}{Logical.  Should the percentage (between 0 and 100, default)
or the proportion (between 0 and 1) of significant gene sets be returned?}

\item{reps}{Integer. Number of replications. Defaults to 100.}

\item{rep.block.size}{Integer. When running in parallel, splits \code{reps}
into blocks of the indicated size. Defaults to -1, which indicates to not  
partition \code{reps}.}

\item{summarize}{Logical. If \code{TRUE} (default) returns the mean (\code{\link{mean}})
and the standard deviation (\code{\link{sd}}) of the proportion of significant
gene sets across \code{reps} replications. Use \code{FALSE} to return the full 
vector storing the proportion of significant gene sets for each replication.}

\item{save2file}{Logical. Should results be saved to file for subsequent
benchmarking?  Defaults to \code{FALSE}.}

\item{out.dir}{Character.  Determines the output directory where results are
saved to.  Defaults to \code{NULL}, which then writes to
\code{tools::R_user_dir("GSEABenchmarkeR")} in case \code{save2file}
is set to \code{TRUE}.}

\item{...}{Additional arguments passed to the selected enrichment method.}
}
\value{
A named numeric vector of length 2 storing mean and standard deviation
of the proportion of significant gene sets across \code{reps} replications 
(\code{summarize=TRUE}); or a numeric vector of length \code{reps} storing the
the proportion of significant gene sets for each replication itself 
(\code{summarize=FALSE}).
}
\description{
This function evaluates the proportion of rejected null hypotheses 
(= the fraction of significant gene sets) of an enrichment method  
when applied to random gene sets of defined size.
}
\examples{

    # loading two datasets from the GEO2KEGG compendium
    geo2kegg <- loadEData("geo2kegg", nr.datasets = 2)

    # only considering the first 1000 probes for demonstration
    geo2kegg <- lapply(geo2kegg, function(d) d[1:1000,]) 

    # preprocessing and DE analysis for two of the datasets
    geo2kegg <- maPreproc(geo2kegg)
    geo2kegg <- runDE(geo2kegg)

    evalRandomGS("camera", geo2kegg[[1]], reps = 3)
    

}
\seealso{
\code{\link{sbea}} and \code{\link{nbea}}
for carrying out set- and network-based enrichment analysis.

\code{\linkS4class{BiocParallelParam}} and \code{\link{register}} for
configuration of parallel computation.
}
\author{
Ludwig Geistlinger <Ludwig.Geistlinger@sph.cuny.edu>
}
