% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRaccessors.R
\name{GRgetGroupVars}
\alias{GRgetGroupVars}
\title{Grouping Variables}
\usage{
GRgetGroupVars(fitData)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}
}
\value{
A vector of grouping variables
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a vector of the grouping variables used to create 
the object.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function returns a vector of the grouping variables used to create the 
object. These are the variables in the dataset that are not averaged over. 
This is simply a convenient accessor function, equivalent to 
\code{metadata(fitData)[[2]]}.
}
\examples{
# Load Case A (example 1) input
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent'))
groupVars = GRgetGroupVars(output1)
groupVars
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}.
}
\author{
Nicholas Clark
}
