% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRbox.R
\name{GRbox}
\alias{GRbox}
\title{Boxplots of a given GR metric}
\usage{
GRbox(
  fitData,
  metric,
  groupVariable,
  pointColor,
  factors = "all",
  wilA = NULL,
  wilB = NULL,
  plotly = TRUE
)
}
\arguments{
\item{fitData}{a SummarizedExperiment object, generated by the GRfit 
function.}

\item{metric}{the GR metric (GR50, GRinf, h_GR, GRmax, GEC50, or GR_AOC) 
or traditional metric (IC50, Einf, h, Emax, EC50, or AUC) that will be used
for the boxplot.}

\item{groupVariable}{the name of the variable from data (e.g. drug,
cell-line, etc.) to select factors from.}

\item{pointColor}{a variable that defines the coloring of the points
overlayed on the boxplot.}

\item{factors}{a vector of values of "groupVariable" of data that define
which variables to make boxplots for. By default, a separate boxplot is made
for each unique value of groupVariable.}

\item{wilA}{one value or a vector of values from "factors", i.e. 
a subset of the boxplots. If specified, a one-sided Wilcoxon rank sum test 
(wilcox.test) will be performed between "wilA" and "wilB" and 
the results will be displayed on the figure. The null hypothesis 
that the values from "wilA" and "wilB" have the same mean will 
be tested against the alternative hypothesis that the mean of the 
"wilB" values is greater than that of the "wilA" values.}

\item{wilB}{one value or a vector of values from "factors", i.e. 
a subset of the boxplots (not overlapping "wilA").}

\item{plotly}{a logical value indicating whether to output a ggplot2 graph
or an interactive ggplotly graph}
}
\value{
ggplot2 or ggplotly boxplots of the factors along the x-axis, with
points colored by the given variable.
}
\description{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function creates boxplots according to the parameters below.
}
\details{
Given a SummarizedExperiment object created by \code{\link{GRfit}},
this function creates boxplots of a given GR metric (GR50, GRmax, etc.) or 
traditional metric (IC50, Emax, etc.) 
for values of the grouping variable. The results can be viewed in a static
ggplot image or an interactive plotly graph.

By default, a boxplot is created for all unique
values of the grouping variable. The "factors" parameter can be used to
specify a smaller subset of values for which to create boxplots.
Points are overlayed on the boxplots and
they can be colored by the variable specified in the pointColor parameter.
If pointColor is set to NULL, the points will all be black. The results can
be viewed in a static ggplot image or an interactive plotly graph.
}
\examples{
# Load Case A (example 1) input
\dontrun{
data("inputCaseA")
head(inputCaseA)
# Run GRfit function with case = "A"
output1 = GRfit(inputData = inputCaseA,
groupingVariables = c('cell_line','agent', 'perturbation','replicate',
'time'))
GRbox(output1, metric ='GRinf',
groupVariable = 'cell_line', pointColor = 'agent' , factors = c('BT20',
'MCF10A'))
GRbox(output1, metric ='GRinf',
groupVariable = 'cell_line', pointColor = 'cell_line' ,
factors = c('BT20', 'MCF10A'), plotly = FALSE)
GRbox(output1, metric = 'GR50', groupVariable = 'cell_line',
pointColor = 'cell_line', wilA = "BT20", wilB = c("MCF7","MCF10A"))
}
}
\seealso{
To create the object needed for this function, see
\code{\link{GRfit}}. For other visualizations, see \code{\link{GRdrawDRC}}
and \code{\link{GRscatter}}. For online GR calculator and browser, see
\url{http://www.grcalculator.org}.
}
\author{
Nicholas Clark
}
