% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgeneSim.R
\name{mgeneSim}
\alias{mgeneSim}
\title{Pairwise semantic similarity for a list of genes}
\usage{
mgeneSim(
  genes,
  semData,
  measure = "Wang",
  drop = "IEA",
  combine = "BMA",
  verbose = TRUE
)
}
\arguments{
\item{genes}{A list of Entrez gene IDs}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{drop}{Evidence codes to drop; use \code{NULL} to keep all GO annotations}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, used to combine multiple term scores.}

\item{verbose}{Whether to show a progress bar}
}
\value{
similarity matrix
}
\description{
Calculate pairwise semantic similarities for a given list of genes.
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
mgeneSim(c("835", "5261", "241"), semData = d, measure = "Wang")
}
\references{
Yu et al. (2010) GOSemSim: an R package for measuring semantic similarity among GO terms and gene products.
Bioinformatics, 26(7): 976–978. https://academic.oup.com/bioinformatics/article/26/7/976/211914
}
\seealso{
\code{\link[=goSim]{goSim()}}, \code{\link[=mgoSim]{mgoSim()}}, \code{\link[=geneSim]{geneSim()}}, \code{\link[=mgeneSim]{mgeneSim()}}, \code{\link[=clusterSim]{clusterSim()}}, \code{\link[=mclusterSim]{mclusterSim()}}, \code{\link[=termSim]{termSim()}}

Other similarity: 
\code{\link{clusterSim}()},
\code{\link{geneSim}()},
\code{\link{goSim}()},
\code{\link{mclusterSim}()},
\code{\link{mgoSim}()}
}
\concept{similarity}
