% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclusterSim.R
\name{mclusterSim}
\alias{mclusterSim}
\title{Pairwise semantic similarities for a list of gene clusters}
\usage{
mclusterSim(clusters, semData, measure = "Wang", drop = "IEA", combine = "BMA")
}
\arguments{
\item{clusters}{A list of gene clusters}

\item{semData}{GOSemSimDATA object}

\item{measure}{One of "Resnik", "Lin", "Rel", "Jiang", "TCSS" and "Wang" methods.}

\item{drop}{Evidence codes to drop; use \code{NULL} to keep all GO annotations}

\item{combine}{One of "max", "avg", "rcmax", "BMA" methods, used to combine multiple term scores.}
}
\value{
similarity matrix
}
\description{
Calculate pairwise semantic similarities for a list of gene clusters.
}
\examples{
d <- godata('org.Hs.eg.db', ont = "MF", computeIC = FALSE)
cluster1 <- c("835", "5261", "241")
cluster2 <- c("578", "582")
cluster3 <- c("307", "308", "317")
clusters <- list(a = cluster1, b = cluster2, c = cluster3)
mclusterSim(clusters, semData = d, measure = "Wang")
}
\references{
Yu et al. (2010) GOSemSim: an R package for measuring semantic similarity among GO terms and gene products.
Bioinformatics, 26(7): 976–978. https://academic.oup.com/bioinformatics/article/26/7/976/211914
}
\seealso{
\code{\link[=goSim]{goSim()}}, \code{\link[=mgoSim]{mgoSim()}}, \code{\link[=geneSim]{geneSim()}}, \code{\link[=mgeneSim]{mgeneSim()}}, \code{\link[=clusterSim]{clusterSim()}}, \code{\link[=mclusterSim]{mclusterSim()}}, \code{\link[=termSim]{termSim()}}

Other similarity: 
\code{\link{clusterSim}()},
\code{\link{geneSim}()},
\code{\link{goSim}()},
\code{\link{mgeneSim}()},
\code{\link{mgoSim}()}
}
\concept{similarity}
