% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{save_gnet}
\alias{save_gnet}
\title{Save the GNET2 results}
\usage{
save_gnet(gnet_result, save_path = ".", num_module = 10, max_gene_num = 100)
}
\arguments{
\item{gnet_result}{Results returned by gnet().}

\item{save_path}{path to save files}

\item{num_module}{The number of modules with highest score to plot.}

\item{max_gene_num}{The max number of genes to show in the heatmap.}
}
\value{
None
}
\description{
Save the edge list, group index of each gene and plot the top groups
}
\examples{
set.seed(1)
init_group_num = 5
init_method = 'boosting'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
save_gnet(gnet_result)
}
