% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_module.R
\name{gnet}
\alias{gnet}
\title{Run GNET2}
\usage{
gnet(
  input,
  reg_names,
  init_method = "boosting",
  init_group_num = 4,
  max_depth = 3,
  cor_cutoff = 0.9,
  min_divide_size = 3,
  min_group_size = 2,
  max_iter = 5,
  heuristic = TRUE,
  max_group = 0,
  force_split = 0.5,
  nthread = 4
)
}
\arguments{
\item{input}{A SummarizedExperiment object, or a p by n matrix of expression data of p genes and n samples,
for example log2 RPKM from RNA-Seq.}

\item{reg_names}{A list of potential upstream regulators names, for example a list of known transcription factors.}

\item{init_method}{Cluster initialization, can be "boosting" or "kmeans", default is using "boosting".}

\item{init_group_num}{Initial number of function clusters used by the algorithm.}

\item{max_depth}{max_depth Maximum depth of the tree.}

\item{cor_cutoff}{Cutoff for within group Pearson correlation coefficient, if all data belong to a node have
average correlation greater or equal to this, the node would not split anymore.}

\item{min_divide_size}{Minimum number of data belong to a node allowed for further split of the node.}

\item{min_group_size}{Minimum number of genes allowed in a group.}

\item{max_iter}{Maxumum number of iterations allowed if not converged.}

\item{heuristic}{If the splites of the regression tree is determined by k-means heuristicly.}

\item{max_group}{Max number of group allowed for the first clustering step, default equals init_group_num and is set to 0.}

\item{force_split}{Force split the largest gene group into smaller groups by kmeans. Default is 0.5(Split if it contains more than half target genes)}

\item{nthread}{Number of threads to run GBDT based clustering}
}
\value{
A list of expression data of genes, expression data of regulators, within group score, table of tree 
structure and final assigned group of each gene.
}
\description{
Build regulation modules by iteratively perform regulator assigning and Gene assigning, until the 
assignment of genes did not change, or max number of iterations reached.
}
\examples{
set.seed(1)
init_group_num = 8
init_method = 'boosting'
exp_data <- matrix(rnorm(50*10),50,10)
reg_names <- paste0('TF',1:5)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))
gnet_result <- gnet(se,reg_names,init_method,init_group_num)
}
