\name{arrayPersp}
\alias{arrayPersp}
\alias{arrayPersp.default}
\alias{arrayPersp.arrayCGH}
\encoding{latin1}
\title{Perspective image of microarray spots statistic}
\description{
The function \code{arrayPersp} creates perspective images of shades of gray or colors that correspond to the values of a statistic for each spot on the array. The statistic can be the intensity log-ratio, a spot quality measure (e.g. spot size or shape), or a test statistic. This function can be used to explore whether there are any spatial effects in the data, for example, print-tip or cover-slip effects.
}
\usage{

\method{arrayPersp}{default}(Statistic, Col, Row,
                   ArrCol, ArrRow, SpotCol, SpotRow,
                   mediancenter=FALSE,
                   col=myPalette("green","red","yellow"),
                   zlim=zlim, bar=TRUE, ...)


\method{arrayPersp}{arrayCGH}(arrayCGH, variable,
   	            mediancenter=FALSE,
		    col=myPalette("green","red","yellow"),
	            zlim=zlim, bar=TRUE, ...)

}

\arguments{

  \item{arrayCGH}{Object of class \code{\link{arrayCGH}}.}
  \item{variable}{Variable to be plotted}
  \item{Statistic}{Statistic to be plotted.}
  \item{Col}{Vector of columns coordinates.}
  \item{Row}{Vector of rows coordinates.}
  \item{ArrCol}{Number of columns for the blocs.}
  \item{ArrRow}{Number of rows for the blocs.}
  \item{SpotCol}{Number of column for each bloc.}
  \item{SpotRow}{Number of rows for each bloc.}
  \item{mediancenter}{If \code{mediancenter=TRUE}, values of \code{Statistic} are median-centered.}
  \item{col}{List of colors such as that generated by \code{Palettes}. In addition to these color palettes functions, a new function \code{\link{myPalette}} was defined to generate color palettes from user supplied low, middle, and high color values. }
  \item{zlim}{Numerical vector of length 2 giving the extreme values of
    \code{z} to associate with colors \code{low} and \code{high} of
    \code{\link{myPalette}}. By default \code{zlim} is the range of
    \code{z}.  Any values of \code{z} outside
    the interval \code{zlim} will be truncated to the relevant limit.}
  \item{bar}{If \code{bar=TRUE}, a calibration color bar is shown to the right of the image.}
  \item{...}{Graphical parameters can be given as arguments to function
\code{persp}.}

  N.B. : Col takes the values in 1:arrayRow*SpotRow and Row takes the
  values in 1:arrayCol*SpotCol



  }


\value{An image is created on the current graphics device.}

\note{People interested in tools dealing with array CGH analysis can
  visit our web-page \url{http://bioinfo.curie.fr}.}

\author{Philippe Hupé, \email{glad@curie.fr}.}

\seealso{\code{persp}, \code{\link{arrayPlot}}, \code{\link{myPalette}}.}

\keyword{hplot}

\examples{

\dontrun{
data(arrayCGH)


# object of class arrayCGH

array <- list(arrayValues=array2, arrayDesign=c(4,4,21,22))
class(array) <- "arrayCGH"

arrayPersp(array,"Log2Rat", main="Perspective image of array CGH",
           box=FALSE, theta=110, phi=40)

}

}

