% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightedMultipleLm.R
\name{weightedMultipleLm}
\alias{weightedMultipleLm}
\title{weightedMultipleLm}
\usage{
weightedMultipleLm(x, y, w = rep(1, nrow(x))/nrow(x))
}
\arguments{
\item{x}{a matrix of numeric values in the size of genes x featureA}

\item{y}{a matrix of numeric values in the size of genes x featureB}

\item{w}{a vector of numeric values indicating the weights of genes}
}
\value{
a matrix of numeric values in the size of featureA*featureB, 
indicating the weighted multiple regression coefficients
}
\description{
weightedMultipleLm solves the weighted multiple linear regression model via 
matrix operation
}
\examples{


# load data
data(heart.metaXcan)
gene <- heart.metaXcan$gene_name

# extract the imputed Z-score of gene differential expression, which follows 
# the normal distribution
fc <- heart.metaXcan$zscore

# use as weights the prediction R^2 and the fraction of imputation-used SNPs 
usedFrac <- heart.metaXcan$n_snps_used / heart.metaXcan$n_snps_in_cov
r2 <- heart.metaXcan$pred_perf_r2
weights <- usedFrac*r2

# build a new data frame for the following weighted linear regression-based 
# enrichment analysis
data <- data.frame(gene,fc,weights)
head(data)

net <- MSigDB.KEGG.Pathway$net

# intersect the permuated genes with the gene sets of interest
data2 <- orderedIntersect( x = data , by.x = data$gene , 
by.y = rownames(net)  )
net2 <- orderedIntersect( x = net , by.x = rownames(net) , 
by.y = data$gene  )
all( rownames(net2) == as.character(data2$gene) )

# perform the weighted multiple linear regression 
observedTstats = weightedMultipleLm( x=net2 , y=data2$fc, w=data2$weights )

# calculate the p values of the weighted multiple regression coefficients
observedPval = 2 * pt(abs(observedTstats), df=sum(weights>0,na.rm=TRUE)-2, 
lower.tail=FALSE)

res = data.frame( observedTstats , observedPval )
head(res)

}
\seealso{
\code{\link{orderedIntersect}}; \code{\link{matrixPval}};
}
\author{
Shijia Zhu, \email{shijia.zhu@mssm.edu}
}
