% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixPval.R
\name{matrixPval}
\alias{matrixPval}
\title{matrixPval}
\usage{
matrixPval(r, df)
}
\arguments{
\item{r}{a vector or a matrix of Pearson correlation coefficients taking 
values in [-1,+1]}

\item{df}{the degree of freedom}
}
\value{
a vector or matrix of p values taking values in [0,1]
}
\description{
matrixPval calculates the p values for the correlation coefficients based on 
t-statistics
}
\examples{


r <- cor(USArrests)
df <- nrow(USArrests) - 2
pval1 <- matrixPval(r,df)

pval2 <- matrix(ncol=ncol(USArrests),nrow=ncol(USArrests),data=0)
for(i in 1:ncol(USArrests))
{
   for(j in 1:ncol(USArrests))
   {
     pval2[i,j] <- cor.test(USArrests[,i],USArrests[,j])$p.val
   }
}

head(pval1)
head(pval2)


}
