% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdcRNAMerge.R
\name{gdcRNAMerge}
\alias{gdcRNAMerge}
\title{Merge RNA/miRNAs raw counts data}
\usage{
gdcRNAMerge(metadata, path, data.type, organized = FALSE)
}
\arguments{
\item{metadata}{metadata parsed from \code{\link{gdcParseMetadata}}}

\item{path}{path to downloaded files for merging}

\item{data.type}{one of \code{'RNAseq'} and \code{'miRNAs'}}

\item{organized}{logical, whether the raw counts data have already
been organized into a single folder (eg., data downloaded by the
'GenomicDataCommons' method are already organized). 
Default is \code{FALSE}.}
}
\value{
A dataframe or numeric matrix of raw counts data with rows 
    are genes or miRNAs and columns are samples
}
\description{
Merge raw counts data that is downloaded from GDC to a 
    single expression matrix
}
\examples{
####### Merge RNA expression data #######
metaMatrix <- gdcParseMetadata(project.id='TARGET-RT', 
    data.type='RNAseq')
\dontrun{rnaExpr <- gdcRNAMerge(metadata=metaMatrix, path='RNAseq/', 
    data.type='RNAseq')}
}
\author{
Ruidong Li and Han Qu
}
