% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getSDReadRef}
\alias{getSDReadRef}
\alias{getSDReadRef,GbsrGenotypeData-method}
\title{Obtain standard deviations of total reference read counts
per SNP or per sample}
\usage{
getSDReadRef(object, target = "marker", valid = TRUE, ...)

\S4method{getSDReadRef}{GbsrGenotypeData}(object, target, valid)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{target}{Either of "marker" and "sample".}

\item{valid}{A logical value. See details.}

\item{...}{Unused.}
}
\value{
A numeric vector of the standard deviations of
reference allele reads per marker.
}
\description{
Obtain standard deviations of total reference read counts
per SNP or per sample
}
\details{
You need to execute \code{\link[=countRead]{countRead()}} to calculate summary statistics to be
obtained via this function.
If \code{valid = TRUE}, the chromosome information of markers which are
labeled \code{TRUE} in the \link{sample} slot will be returned.
\code{\link[=validMar]{validMar()}} tells you which samples are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Calculate means, standard deviations, quantiles of read counts
# per marker and per sample with or without standardization of
# the counts and store them in the [marker] and [sample] slots
# of the [GbsrGenotypeData] object.
gds <- countRead(gds)

getSDReadRef(gds)

# Close the connection to the GDS file.
closeGDS(gds)

}
