% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getInfo}
\alias{getInfo}
\alias{getInfo,GbsrGenotypeData-method}
\title{Obtain information stored in the "annotation/info" node}
\usage{
getInfo(object, var, valid = TRUE, chr = NULL, ...)

\S4method{getInfo}{GbsrGenotypeData}(object, var, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{var}{A string to indicate which annotation info should be retrieved.}

\item{valid}{A logical value. See details.}

\item{chr}{A index to specify chromosome to get information.}

\item{...}{Unused.}
}
\value{
A numeric vector of data stored in INFO node of the GDS file.
}
\description{
The "annotation/info" node stores annotation infromation of markers obtained
via SNP calling tools like bcftools and GATK.
}
\details{
If \code{valid = TRUE}, the information of the markers which are labeled \code{TRUE}
in the "valid" column of the "marker" slot will be returned. If you need the
number of over all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds_fn <- system.file("extdata", "sample.gds", package = "GBScleanR")
gds <- loadGDS(gds_fn)

# Get mapping qualities (MQ) of markers.
mq <- getInfo(gds, "MQ")

# Close the connection to the GDS file.
closeGDS(gds)
}
