% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Methods-GbsrGenotypeData.R
\name{getFixedParameter}
\alias{getFixedParameter}
\alias{getFixedParameter,GbsrGenotypeData-method}
\title{Get fixed allele read biases and mismapping rate}
\usage{
getFixedParameter(object, valid = TRUE, chr = NULL, ...)

\S4method{getFixedParameter}{GbsrGenotypeData}(object, valid, chr)
}
\arguments{
\item{object}{A \link{GbsrGenotypeData} object.}

\item{valid}{A logical value. See details.}

\item{chr}{A integer or string to specify chromosome to get information.}

\item{...}{Unused.}
}
\value{
A numeric vector of fixed allele read biases.

A \link{GbsrGenotypeData} object after adding dominant marker information
}
\description{
Get fixed allele read biases and mismapping rates of markers
}
\details{
If \code{valid = TRUE}, A logical vector for the markers which are labeled \code{TRUE} in
the "valid" column of the "marker" slot will be returned. If you need check
the dominant markers in all markers, set \code{valid = FALSE}. \code{\link[=validMar]{validMar()}} tells you
which markers are valid.
}
\examples{
vcf_fn <- system.file("extdata", "sample.vcf", package = "GBScleanR")
gds_fn <- tempfile("sample", fileext = ".gds")
gbsrVCF2GDS(vcf_fn = vcf_fn, out_fn = gds_fn, force = TRUE)

# Load data in the GDS file and instantiate a [GbsrGenotypeData] object.
gds <- loadGDS(gds_fn)

# Not run.
# Run estGeno() and reuse the estimated parameters in the second run.
# gds <- makeScheme(gds, generation = 2, crosstype = "self")
# gds <- estGeno(gds)
# fixed_param <- getFixedParameter(gds)
# gds <- setFixedParameter(gds,
#                          bias = fixed_param$bias,
#                          mismap = fixed_param$mismap)
# gds <- estGeno(gds, optim = FALSE, call_threshold = 0.5)

# Close the connection to the GDS file
closeGDS(gds)

}
\seealso{
\code{\link[=setFixedParameter]{setFixedParameter()}}
}
