% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_selection.R
\name{GARS_Selection}
\alias{GARS_Selection}
\title{Perform the "Roulette Wheel" or the "Tournament" selection}
\usage{
GARS_Selection(chr.pop, type = c("RW", "TS"), fitn.values)
}
\arguments{
\item{chr.pop}{A matrix or a data.frame representing the chromosomes
population: each column is a chromosome and each element corresponds
 to the feature position in the data matrix}

\item{type}{The type of selection method; Roulette Wheel ("RW")
and Tournament Selection ("TS") are allowed. Default is "RW"}

\item{fitn.values}{A numeric vector where each element corresponds to
the fitness score of each chromosome in 'chr.pop'}
}
\value{
A matrix representing the "selected" population.
The dimensions of this matrix are the same of 'chr.pop'.
}
\description{
This function implements two kind of GA Selection step:
the "Roulette Wheel" and the "Tournament" selection.
}
\examples{
# use example data:
data(GARS_popul)
data(GARS_Fitness_score)
selected_pop <- GARS_Selection(GARS_popul, "RW", GARS_Fitness_score)

}
\seealso{
\code{\link{GARS_Mutation}},
\code{\link{GARS_Crossover}},
\code{\link{GARS_Elitism}},
}
\author{
Mattia Chiesa, Luca Piacentini
}
