% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_mutation.R
\name{GARS_Mutation}
\alias{GARS_Mutation}
\title{Perform the Mutation step}
\usage{
GARS_Mutation(chr.pop, mut.rate = 0.01, totFeats)
}
\arguments{
\item{chr.pop}{A matrix or a data.frame representing the chromosomes
population: each column is a chromosome and each element correspond
 to the feature position in the data matrix}

\item{mut.rate}{The probability to apply a random mutation to each
element. It must be between 0 and 1. Default is 0.01}

\item{totFeats}{The total number of features. Often, it corresponds
to number of columns of the data matrix}
}
\value{
A matrix representing the "mutated" population. The dimensions of
this matrix are the same of 'chr.pop'
}
\description{
This function implements the mutation step in the GA.
First, it checks and replace duplicate features in each chromosomes;
then, random mutation are applied to the entire population.
}
\examples{
# use example data:
data(GARS_popul)
data(GARS_data_norm)

mutated_pop <- GARS_Mutation(GARS_popul, mut.rate=0.1,
 dim(GARS_data_norm)[2])

}
\seealso{
\code{\link{GARS_Elitism}},
\code{\link{GARS_Selection}},
\code{\link{GARS_Crossover}},
}
\author{
Mattia Chiesa, Luca Piacentini
}
