% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GARS_fitnessFunction.R
\name{GARS_FitFun}
\alias{GARS_FitFun}
\title{This function implements the Fitness Function of GARS}
\usage{
GARS_FitFun(data, classes, chr.pop)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object or a matrix or
a data.frame. In case of matrix or data.frame:
\itemize{
 \item Rows and Cols have to be, respectively, observations
 and features. The variables are tipically genes;
 \item GARS also accept other -omic features as well as any
 continuous or factorial variables
 (e.g. sex, age, cholesterol level,...);
 \item Usually the number of observation is << than the number
 of features
}'}

\item{classes}{A vector of type "factor" with \code{nrow(data)} elements.
Each element represents the class label for each observation.}

\item{chr.pop}{A matrix or a data.frame representing the chromosomes
population: each column is a chromosome and each element corresponds
 to the feature position in the expression data matrix}
}
\value{
A numeric vector where each element corresponds to
 the fitness score of each chromosome in 'chr.pop'
}
\description{
In GARS the Fitness Function consists in calculating the
Averaged Silhouette Index after a Multi-Dimensional Scaling
}
\examples{
# use example data:
data(GARS_data_norm)
data(GARS_classes)
data(GARS_popul)
fitness_scores <- GARS_FitFun(GARS_data_norm, GARS_classes, GARS_popul)

}
\seealso{
\code{\link{GARS_create_rnd_population}}
}
\author{
Mattia Chiesa, Luca Piacentini
}
