% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchVariantSets.R
\name{searchVariantSets}
\alias{searchVariantSets}
\title{searchVariantSets function}
\usage{
searchVariantSets(host, datasetId, nrows = Inf, responseSize = NA_integer_)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{datasetId}{Id of the dataset to search.}

\item{nrows}{Number of rows of the data frame returned by this function.
If not defined, the function will return all entries. If the number of
available entries is less than the value of this this parameter, the function
will silently return only the available entries.}

\item{responseSize}{Specifies the number of entries to be returned by the
server until reach the number of rows defined in \code{nrows} parameter or
until get all available entries. If not defined, the server will return the
allowed maximum reponse size. Increasing this the value of this parameter will
reduce the number of requests and reducing the time required. The will not
respect this parameter if the value if larger than its maximum response size.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Search for for variant sets (VCF files).
}
\details{
This request maps to the body of \code{POST host/variantsets/search}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
searchVariantSets(host, datasetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/variant_service.proto.html#SearchVariantSets}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{getVariantSet}}
}
