% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeVCFHeaderFromGA4GHResponse.R
\name{makeVCFHeaderFromGA4GHResponse}
\alias{makeVCFHeaderFromGA4GHResponse}
\title{makeVCFHeaderFromGA4GHResponse function}
\usage{
makeVCFHeaderFromGA4GHResponse(variantSet)
}
\arguments{
\item{variantSet}{\code{DataFrame} generated by
\code{\link{getVariantSet}} function.}
}
\value{
\code{\link{VCFHeader}} object.
}
\description{
Convert \code{DataFrame} output from
\code{\link{getVariantSet}} function to \code{\link{VCFHeader}} class.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 1)$id
variantId <- searchVariants(host, variantSetId, "1", 15031, 15031)$id
variant <- getVariant(host, variantId)

makeVCFFromGA4GHResponse(variant)
}
}
\seealso{
\code{\link{getVariantSet}}, \code{\link{VCFHeader}},
\code{\link{DataFrame}}
}
