% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariantAnnotationSet.R
\name{getVariantAnnotationSet}
\alias{getVariantAnnotationSet}
\title{Gets getVariantAnnotationSet function}
\usage{
getVariantAnnotationSet(host, variantAnnotationSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{variantAnnotationSetId}{ID of variant annotation set.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a variant annotation set by its ID.
}
\details{
This function requests
\code{GET host/variantannotationsets/variantAnnotationSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
datasetId <- searchDatasets(host, nrows = 1)$id
variantSetId <- searchVariantSets(host, datasetId, nrows = 2)$id[2]
id <- searchVariantAnnotationSets(host, variantSetId, nrows = 1)$id
getVariantAnnotationSet(host, variantAnnotationSetId = id)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/allele_annotation_service.proto.html#GetVariantAnnotationSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}},
\code{\link{searchVariantAnnotationSets}}
}
