% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getReferenceSet.R
\name{getReferenceSet}
\alias{getReferenceSet}
\title{getReferenceSet function}
\usage{
getReferenceSet(host, referenceSetId)
}
\arguments{
\item{host}{URL of GA4GH API data server.}

\item{referenceSetId}{The ID of the ReferenceSet to be retrieved.}
}
\value{
\code{\link{DataFrame}} object.
}
\description{
Get a reference set by its ID.
}
\details{
This function requests \code{GET host/referencesets/referenceSetId}.
}
\examples{
host <- "http://1kgenomes.ga4gh.org/"
\dontrun{
referenceSetId <- searchReferenceSets(host, nrows = 1)$id
getReferenceSet(host, referenceSetId)
}
}
\references{
\href{https://ga4gh-schemas.readthedocs.io/en/latest/schemas/reference_service.proto.html#GetReferenceSet}{Official documentation}.
}
\seealso{
\code{\link{DataFrame}}, \code{\link{searchReferenceSets}}
}
