% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVarImpact.R
\name{plotVarImpact}
\alias{plotVarImpact}
\title{Plot the Impact of Variants on G4 Formation}
\usage{
plotVarImpact(
  gr,
  p_colors = c(fill_2d = "#376597", diagonal = "#b22d2d", density_fill = "#6ca4d6",
    density_line = "#2d69b0", vline = "#1f77b4")
)
}
\arguments{
\item{gr}{A \code{GRanges} object containing G4Hunter scores and
associated metadata.
Required metadata columns include:
\itemize{
  \item \code{G4.info.max_score}: Numeric vector of
  original maximum G4Hunter scores.
  \item \code{mutated.max_score}: Numeric vector of
  maximum G4Hunter scores after mutation.
  \item \code{score.diff}: Numeric vector of score differences.
}}

\item{p_colors}{A character vector of five colors used for plotting.
The vector must include:
\describe{
  \item{\code{"fill_2d"}}{Fill Color for the 2D density plot.}
  \item{\code{"diagonal"}}{Color for the diagonal line in the 2D
  density plot.}
  \item{\code{"density_fill"}}{Fill color for the density plot.}
  \item{\code{"density_line"}}{Line color for the density plot.}
  \item{\code{"vline"}}{Color for the vertical line at zero
  in the density plot.}
}}
}
\value{
A \code{ggplot} object combining two subplots:
  \enumerate{
    \item 2D density plot of the absolute maximum G4Hunter scores
    before and after mutation.
    \item Density plot of the maximum G4Hunter score differences.
  }
}
\description{
This function generates two panels to visualize the impact of variants on
G4 formation:
\enumerate{
  \item A 2D density plot of absolute maximum G4Hunter scores before and
  after mutation.
  \item A density plot showing the distribution of score differences.
}
}
\examples{

if (!requireNamespace("BiocManager", quietly = TRUE)) {
  install.packages("BiocManager")
}

if (!requireNamespace("GenomicRanges", quietly = TRUE)) {
  BiocManager::install("GenomicRanges")
}

if (!requireNamespace("BSgenome.Hsapiens.UCSC.hg19", quietly = TRUE)) {
  BiocManager::install("BSgenome.Hsapiens.UCSC.hg19")
}

library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg19)

hg19 <- BSgenome.Hsapiens.UCSC.hg19
chr21_seq <- DNAStringSet(hg19$chr21)
# Chromosome name is needed
names(chr21_seq) <- "chr21"

G4 <- G4HunterDetect(chr21_seq)

# Load SNVs
data(snp_gr)

res_snp <- G4VarImpact(G4, snp_gr, ref_col = "ref", alt_col = "alt")
plotVarImpact(res_snp)
}
\seealso{
\code{\link{G4VarImpact}} for computing the effects of variants
on G4 formation,
and \code{\link{filterVarImpact}} for screening G4s whose formation
propensity may be impaired by variants.
}
