% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportG4.R
\name{exportG4}
\alias{exportG4}
\title{Export Predicted G4s to a File}
\usage{
exportG4(
  G4 = NULL,
  filename = NULL,
  include_metadata = TRUE,
  revcomp_antisense = TRUE
)
}
\arguments{
\item{G4}{A \code{GRanges} object returned by \code{G4HunterDetect}.}

\item{filename}{A \code{character} string specifying the output file path.
The file extension must be one of:
\code{.txt}, \code{.csv}, or \code{.xlsx}.}

\item{include_metadata}{A \code{logical} value.
Whether to include global metadata (G4 prediction parameters) in the output.
Default is \code{TRUE}.}

\item{revcomp_antisense}{A \code{logical} value. Whether to
reverse-complement sequences on the antisense (negative) strand.
Default is \code{TRUE}.}
}
\value{
Invisibly returns a \code{data.frame} object.
}
\description{
This function exports a \code{GRanges} object containing predicted G4s
generated by the \code{G4HunterDetect} function from the G4SNVHunter
package, to a file in TXT, CSV, or XLSX format.
}
\examples{
fa_path <- system.file("extdata", "seq.fa", package = "G4SNVHunter")
seq <- loadSequence(seq_path = fa_path)
# Predict G4s
G4_detected <- G4HunterDetect(seq)

out_xlsx <- file.path(tempdir(), "results.xlsx")
out_txt  <- file.path(tempdir(), "results.txt")
out_csv  <- file.path(tempdir(), "results.csv")

exportG4(G4_detected, out_xlsx)
exportG4(G4_detected, out_txt, include_metadata = FALSE)
exportG4(G4_detected, out_csv, revcomp_antisense = FALSE)

unlink(c(out_xlsx, out_txt, out_csv))
}
