% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{generatePrototypes}
\alias{generatePrototypes}
\title{Generate a Self Organizing Map}
\usage{
generatePrototypes(data, verbose = FALSE, size = NULL)
}
\arguments{
\item{data}{the marker intensities}

\item{verbose}{should the progress be printed out}

\item{size}{The optimal grid size for the Self Organizing Map}
}
\value{
the self organizing map object
}
\description{
A self organizing map of the marker intensities is generated and the
prototypes are returned.
The grid size is determined automatically
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
generatePrototypes(risom_dat[, risomMarkers])

}
