% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreFunctions.R
\name{estimateNumCluster}
\alias{estimateNumCluster}
\title{Estimate number of clusters}
\usage{
estimateNumCluster(data, method = c("Discriminant", "Distance"), kSeq = 2:20)
}
\arguments{
\item{data}{the SOM object generated by generatePrototypes(), or an object
of class SingleCellExperiment or SpatialExperiment.}

\item{method}{one of Discriminant, Distance, Stability. By default,
everything is run}

\item{kSeq}{a sequence of the number of clusters to try. Default is 2:20
clusters}
}
\value{
A list containing the cluster estimations if a dataframe
or matrix is provided

A SingleCellExperiment with a cluster estimate in it's metadata
if a SingleCellExperiment or SpatialExperiment object is provided
}
\description{
A function for estimating the number of clusters using various method
Methods available are: Discriminant, Distance
(Gap, Silhouette, Slope, Jump, and Within Cluster Distance,) and Instability
}
\examples{
data("risom_dat")
risomMarkers <- c(
  "CD45", "SMA", "CK7", "CK5", "VIM", "CD31", "PanKRT", "ECAD"
)
res <- runFuseSOM(risom_dat, markers = risomMarkers, numClusters = 23)
res.est.k <- estimateNumCluster(res$model, kSeq = 2:25)

}
\author{
Elijah WIllie \href{mailto:ewil3501@uni.sydney.edu.au}{ewil3501@uni.sydney.edu.au}
}
