% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_buildMST.R
\name{TestOutliers}
\alias{TestOutliers}
\title{TestOutliers}
\usage{
TestOutliers(
  fsom,
  madAllowed = 4,
  fsomReference = NULL,
  plotFile = NULL,
  channels = NULL
)
}
\arguments{
\item{fsom}{FlowSOM object}

\item{madAllowed}{Number of median absolute deviations allowed. Default = 4.}

\item{fsomReference}{FlowSOM object to use as reference. If NULL (default),
the original fsom object is used.}

\item{plotFile}{If \code{NULL} (default), no plot will be created. If a 
filepath is given for a pdf, the plot will be written in the
corresponding file}

\item{channels}{If channels are given, the number of outliers in the original
space for those channels will be calculated and added to the
final results table.}
}
\value{
An outlier report
}
\description{
Test if any cells are too far from their cluster centers
}
\details{
For every cluster, the distance from the cells to the cluster centers is
used to label cells which deviate too far as outliers. The threshold is
chosen as the median distance + \code{madAllowed} times the median absolute
deviation of the distances.
}
\examples{
 # Build FlowSom result
 fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
 ff <- flowCore::read.FCS(fileName)
 flowSOM.res <- FlowSOM(ff,
                        compensate = TRUE, transform = TRUE, scale = TRUE,
                        colsToUse = c(9, 12, 14:18),
                        nClus = 10)
   
 # Map new data
 outlier_report <- TestOutliers(flowSOM.res, 
                                madAllowed = 5,
                                channels = flowSOM.res$map$colsUsed)

 # Number of cells which is an outlier for x channels                               
 outlier_on_multiple_markers <- table(rowSums(outlier_report$channel_specific != 0))          
 outlier_type <- paste(GetClusters(flowSOM.res),
                       apply(outlier_report$channel_specific, 1, paste0, collapse = ""))
 outlier_counts <- table(grep(" .*1.*", outlier_type, value = TRUE))
 outliers_of_interest <- names(which(outlier_counts > 10))
 outlier_boolean <- outlier_type \%in\% outliers_of_interest
 
}
\seealso{
\code{\link{FlowSOMSubset}} if you want to get a subset of the
         current data instead of a new dataset
}
