% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_buildSOM.R
\name{SaveClustersToFCS}
\alias{SaveClustersToFCS}
\title{Write FlowSOM clustering results to the original FCS files}
\usage{
SaveClustersToFCS(
  fsom,
  originalFiles,
  preprocessedFiles = NULL,
  selectionColumn = NULL,
  silent = FALSE,
  outputDir = ".",
  suffix = "_FlowSOM.fcs",
  ...
)
}
\arguments{
\item{fsom}{FlowSOM object as generated by BuildSOM}

\item{originalFiles}{FCS files that should be extended}

\item{preprocessedFiles}{FCS files that correspond to the input of FlowSOM,
If NULL (default), the originalFiles are used.}

\item{selectionColumn}{Column of the FCS file indicating the original cell
ids. If NULL (default), no selection is made.}

\item{silent}{If FALSE (default), print some extra output}

\item{outputDir}{Directory to save the FCS files. Default to the
current working directory (".")}

\item{suffix}{Suffix added to the filename. Default _FlowSOM.fcs}

\item{...}{Options to pass on to the read.FCS function (e.g.
truncate_max_range)}
}
\value{
Saves the extended FCS file as [originalName]_FlowSOM.fcs
}
\description{
Write FlowSOM clustering results to the original FCS files
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
flowSOM.res <- FlowSOM(fileName, compensate = TRUE, transform = TRUE,
                      scale = TRUE, colsToUse = c(9, 12, 14:18), nClus = 10)
SaveClustersToFCS(flowSOM.res, fileName)

}
