% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_buildMST.R
\name{NClusters}
\alias{NClusters}
\title{NClusters}
\usage{
NClusters(fsom)
}
\arguments{
\item{fsom}{FlowSOM object}
}
\value{
The number of clusters
}
\description{
Extracts the number of clusters from a FlowSOM object
}
\examples{
 # Build FlowSom result
 fileName <- system.file("extdata", "68983.fcs", package = "FlowSOM")
 ff <- flowCore::read.FCS(fileName)
 flowSOM.res <- FlowSOM(ff,
                        compensate = TRUE, transform = TRUE, scale = TRUE,
                        colsToUse = c(9, 12, 14:18),
                        maxMeta = 10)
 NClusters(flowSOM.res)

}
