% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_deprecated.R
\name{MetaclusterCVs}
\alias{MetaclusterCVs}
\title{MetaclusterCVs}
\usage{
MetaclusterCVs(fsom)
}
\arguments{
\item{fsom}{Result of calling the FlowSOM function}
}
\value{
Metacluster CVs
}
\description{
Compute the coefficient of variation for the metaclusters
}
\examples{
fileName <- system.file("extdata", "68983.fcs", package="FlowSOM")
ff <- flowCore::read.FCS(fileName)
ff <- flowCore::compensate(ff,ff@description$SPILL)
ff <- flowCore::transform(ff,
         flowCore::transformList(colnames(ff@description$SPILL),
                                flowCore::logicleTransform()))
flowSOM.res <- FlowSOM(ff,scale=TRUE,colsToUse=c(9,12,14:18), nClus=10)
cvs <- GetMetaclusterCVs(flowSOM.res)
}
