% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_plotFunctions.R
\name{FlowSOMmary}
\alias{FlowSOMmary}
\title{FlowSOMmary}
\usage{
FlowSOMmary(fsom, plotFile = "FlowSOMmary.pdf")
}
\arguments{
\item{fsom}{FlowSOM object, as generated by \code{\link{FlowSOM}}}

\item{plotFile}{Name of the pdf file that will be generated (default is 
FlowSOMmary.pdf). If \code{NULL}, a list of ggplots will 
be returned.}
}
\value{
Returns a summary of the FlowSOM object
}
\description{
This functions plots a summary of a flowSOM object. It includes a table of 
(meta)cluster data, the flowSOM trees and grid view, the (meta)cluster 
labels, the markers expression, the file distribution if present,
the cluster per metacluster percentage, a t-SNE plot,
and the MFI per metacluster.
}
\examples{
# Identify the files
fcs <- flowCore::read.FCS(system.file("extdata", "68983.fcs", 
                                      package = "FlowSOM"))

# Build a FlowSOM object
flowSOM.res <- FlowSOM(fcs, 
                       scale = TRUE,
                       compensate = TRUE, 
                       transform = TRUE,
                       toTransform = 8:18, 
                       colsToUse = c(9, 12, 14:18),
                       nClus = 10,
                       seed = 1)
                       
FlowSOMmary(flowSOM.res)

}
