% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FitHiC.R
\name{FitHiC}
\alias{FitHiC}
\title{Fit-Hi-C}
\usage{
FitHiC(fragsfile, intersfile, outdir, biasfile = "none", noOfPasses = 1,
  noOfBins = 100, mappabilityThreshold = 1, libname = "",
  distUpThres = -1, distLowThres = -1, visual = FALSE,
  useHiCPro = FALSE)
}
\arguments{
\item{fragsfile}{The path specifies where FRAGSFILE is located in the
file system. FRAGSFILE stores the information about
midpoints (or start indices) of the fragments. It should
consist of 5 columns: first column stands for chromosome
name; third column stands for the midPoint; fourth column
stands for the hitCount; second column and fifth column
can be arbitrary.}

\item{intersfile}{The path specifies where INTERSFILE is located in the
file sytem. INTERSFILE stores the information about
interactions between fragment pairs. It should consist
of 5 columns: first column and third column stand for
the chromosome names of the fragment pair; second column
and fourth column stand for midPoints of the fragment
pair; fifth column stands for hitCount.}

\item{outdir}{The path specifies where the output files will be stored
in the file system. If the path does not exist, it will be
automatically created.}

\item{biasfile}{The path specifies where BIASFILE is located in the file
system. BIASFILE stores the information about biases
calculated by ICE for each locus. It should consist of
3 columns: first column stands for chromosome name; second
column stands for the midPoint; third column stands for
the bias. This argument is OPTIONAL.}

\item{noOfPasses}{Number of passes after the initial (before) fit. DEFAULT
is 1 (after).}

\item{noOfBins}{Number of equal-occupancy (count) bins. Default is 100.}

\item{mappabilityThreshold}{Minimum number of hits per locus that has to
exist to call it mappable. DEFAULT is 1.}

\item{libname}{Name of the library that is analyzed to be used for plots.
DEFAULT is empty.}

\item{distUpThres}{Upper bound on the intra-chromosomal distance range
(unit: base pairs). DEFAULT is no limit.}

\item{distLowThres}{Lower bound on the intra-chromosomal distance range
(unit: base pairs). DEFAULT is no limit.}

\item{visual}{Use this flag for generating plots. DEFAULT is False.}

\item{useHiCPro}{Whether to use HiC-Pro preprocessed data. DEFAULT is False.}
}
\value{
None
}
\description{
Fit-Hi-C is a tool for assigning statistical confidence estimates
to intra-chromosomal contact maps produced by genome-wide genome
architecture assays such as Hi-C.
}
\examples{
fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
intersfile <- system.file("extdata", "contactCounts/Duan_yeast_EcoRI.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Duan_yeast_EcoRI")
FitHiC(fragsfile, intersfile, outdir, libname="Duan_yeast_EcoRI",
    distUpThres=250000, distLowThres=10000)

fragsfile <- system.file("extdata", "fragmentLists/Duan_yeast_HindIII.gz",
    package = "FitHiC")
intersfile <- system.file("extdata", "contactCounts/Duan_yeast_HindIII.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Duan_yeast_HindIII")
FitHiC(fragsfile, intersfile, outdir, libname="Duan_yeast_HindIII",
    distUpThres=250000, distLowThres=10000)

fragsfile <- system.file("extdata",
    "fragmentLists/Dixon_hESC_HindIII_hg18_combineFrags10_chr1.gz",
    package = "FitHiC")
intersfile <- system.file("extdata",
    "contactCounts/Dixon_hESC_HindIII_hg18_combineFrags10_chr1.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Dixon_hESC_HindIII_hg18_combineFrags10_chr1")
FitHiC(fragsfile, intersfile, outdir,
    libname="Dixon_hESC_HindIII_hg18_combineFrags10_chr1", noOfBins=200,
    distUpThres=5000000, distLowThres=50000)

fragsfile <- system.file("extdata",
    "fragmentLists/Dixon_mESC_HindIII_mm9_combineFrags10_chr1.gz",
    package = "FitHiC")
intersfile <- system.file("extdata",
    "contactCounts/Dixon_mESC_HindIII_mm9_combineFrags10_chr1.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Dixon_mESC_HindIII_mm9_combineFrags10_chr1")
FitHiC(fragsfile, intersfile, outdir,
    libname="Dixon_mESC_HindIII_mm9_combineFrags10_chr1", noOfBins=200,
    distUpThres=5000000, distLowThres=50000)

fragsfile <- system.file("extdata",
    "fragmentLists/Dixon_hESC_HindIII_hg18_w40000_chr1.gz",
    package = "FitHiC")
intersfile <- system.file("extdata",
    "contactCounts/Dixon_hESC_HindIII_hg18_w40000_chr1.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Dixon_hESC_HindIII_hg18_w40000_chr1")
FitHiC(fragsfile, intersfile, outdir,
    libname="Dixon_hESC_HindIII_hg18_w40000_chr1", noOfBins=50,
    distUpThres=5000000, distLowThres=50000)

fragsfile <- system.file("extdata",
    "fragmentLists/Dixon_hESC_HindIII_hg18_w40000_chr1.gz",
    package = "FitHiC")
intersfile <- system.file("extdata",
    "contactCounts/Dixon_hESC_HindIII_hg18_w40000_chr1.gz",
    package = "FitHiC")
outdir <- file.path(getwd(), "Dixon_hESC_HindIII_hg18_w40000_chr1.afterICE")
biasfile <- system.file("extdata",
    "biasPerLocus/Dixon_hESC_HindIII_hg18_w40000_chr1.gz",
    package = "FitHiC")
FitHiC(fragsfile, intersfile, outdir, biasfile,
    libname="Dixon_hESC_HindIII_hg18_w40000_chr1", noOfBins=50,
    distUpThres=5000000, distLowThres=50000)

fragsfile <- system.file("extdata", "fragmentLists/data_5000000_abs.bed.gz",
    package = "FitHiC")
intersfile <- system.file("extdata", "contactCounts/data_5000000.matrix.gz",
    package = "FitHiC")
biasfile <- system.file("extdata",
    "biasPerLocus/data_5000000_iced.matrix.biases.gz", package = "FitHiC")
outdir <- file.path(getwd(), "data_5000000")
FitHiC(fragsfile, intersfile, outdir, biasfile, libname="data_5000000",
    distUpThres=500000000, distLowThres=5000000, useHiCPro=TRUE)

}
\author{
Ruyu Tan, \email{rut003@ucsd.edu}
}

